<?php

	// Nom du script : php_mysql_modification_ville.php
	// Auteur : Christian VIGOUROUX
	// Date de création : 01/08/2024
	// Objet : Modification du nom d'une ville dans la table MySQL villes
	//         à partir de l'affichage de la liste des villes (champs id_ville et nom_ville)

	// Désactivation de l'affichage des erreurs PHP
	// pour éviter les fuites dans la réponse JSON
	ini_set('display_errors', 0);
	error_reporting(0);

	// Gestion des requêtes CORS
	if (isset($_SERVER['HTTP_ORIGIN'])) {
		header("Access-Control-Allow-Origin: {$_SERVER['HTTP_ORIGIN']}");
		header('Access-Control-Allow-Credentials: true');
		header('Access-Control-Max-Age: 86400');    // cache d'un jour uniquement
	}
	// Vérification que la méthode de la requête est OPTIONS
	if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
		// Vérification que le client a envoyé un en-tête
		// pour spécifier les méthodes autorisées
		if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_METHOD']))
			// Envoi d'un en-tête pour indiquer
			// les méthodes HTTP autorisées (GET, POST, OPTIONS)
			header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
		// Vérification que le client a envoyé un en-tête
		// pour spécifier les en-têtes autorisés
		if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']))
			// Envoi d'un en-tête pour indiquer
			//quels en-têtes HTTP sont autorisés
			header("Access-Control-Allow-Headers: {$_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']}");
		// Arrêt de l'exécution du script pour les requêtes OPTIONS
		// car elles sont préliminaires
		// et ne nécessitent pas de traitement supplémentaire
		exit(0);
	}

	// Gestion des accents et du type de contenu
	header('content-type: application/json; charset=utf-8');

	// Paramètres de connexion à la Base De Données MySQL
	$serveur_mysql = "serveur_mysql";
	$utilisateur_mysql = "utilisateur_mysql";
	$mot_de_passe_mysql = "mot_de_passe_mysql";
	$bdd_mysql = "bdd_mysql";
	
	// Tentative de connexion
	try {
		
		$bdd = new PDO("mysql:host=$serveur_mysql;dbname=$bdd_mysql", $utilisateur_mysql, $mot_de_passe_mysql);
		$bdd->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

		// Récupération des données postées par l'application client (POST)
		$data = json_decode(file_get_contents('php://input'), true);
		$id_ville = $data['id_ville'] ?? null;
		$nom_ville = $data['nom_ville'] ?? null;

		// Validation des données
		if ($id_ville === null || $nom_ville === null) {
			// Données manquantes ou invalides
			echo json_encode(['success' => false, 'message' => 'Données manquantes ou invalides']);
			// Sortie forcée
			exit();
		}

		//
		// Mise à jour du nom de la ville
		//
		// Requête SQL de mise à jours
		$requete_sql = "UPDATE villes SET nom_ville = :nom_ville WHERE id_ville = :id_ville";
		// Intégration des paramètres à la requête SQL
		$stmt = $bdd->prepare($requete_sql);
		$stmt->bindParam(':nom_ville', $nom_ville, PDO::PARAM_STR);
		$stmt->bindParam(':id_ville', $id_ville, PDO::PARAM_INT);
		// Exécution de la requête SQL
		$stmt->execute();

		// Vérification de la réussite de la mise à jour
		if ($stmt->rowCount() > 0) {
			error_log("Mise à jour réussie pour id_ville " . $id_ville);

			// Récupération de la nouvelle liste des villes
			$resultat_sql = $bdd->prepare("SELECT id_ville, nom_ville FROM villes");
			$resultat_sql->execute();
			$villes = $resultat_sql->fetchAll(PDO::FETCH_ASSOC);
			// Envoi de la nouvelle liste à l'application cliente
			echo json_encode(['success' => true, 'data' => $villes]);
		} else {
			// Message d'erreur
			error_log("Aucune mise à jour effectuée pour id_ville " . $id_ville);
			// Envoi du message d'erreur à l'application cliente
			echo json_encode(['success' => false, 'message' => 'Aucune mise à jour effectuée']);
		}
    // Cas d'erreur
	} catch (PDOException $e) {
		// Message d'erreur
		error_log("Erreur de mise à jour : " . $e->getMessage());
		// Envoi du message d'erreur à l'application cliente
		echo json_encode(['success' => false, 'message' => 'Erreur de mise à jour : ' . $e->getMessage()]);
	}

	// Fermeture de la connexion MySQL
	$bdd = null;

?>